// Gulp file
const { src, dest, task, watch, series, parallel } = require('gulp');
const del                  = require('del');
const options              = require("./config"); //options from config.js
const browserSync          = require('browser-sync').create();
const sass                 = require('gulp-sass');
const postcss              = require('gulp-postcss');
const rtlcss               = require('gulp-rtlcss');
const concat               = require('gulp-concat');
const cleanCSS             = require('gulp-clean-css');
const purgecss             = require('gulp-purgecss');
const logSymbols           = require('log-symbols');

//Load Previews on Browser on dev
function livePreview(done){
  browserSync.init({
    files: "./*.html",
    startPath: "./",
    server: {
      baseDir: "./",
    },
    port: options.config.port || 5000
  });
  done();
}
function watchFiles(){
  watch('./**/*.html',series(previewReload));
  watch([options.config.tailwindjs, `${options.paths.src.scss}/**/*`],series(devStyles, previewReload));
  console.log("\n\t" + logSymbols.info,"Watching for Changes..\n");
}
function previewReload(done){
  console.log("\n\t" + logSymbols.info,"Reloading Browser Preview.\n");
  browserSync.reload();
  done();
}

// delete dist
function devClean(){
  console.log("\n\t" + logSymbols.info,"Cleaning dist folder for fresh start.\n");
  return del([options.paths.dist.base]);
}
// generate css
function devStyles(){
  const tailwindcss = require('tailwindcss'); 
  return src(`${options.paths.src.scss}/tailwindcss.scss`).pipe(sass().on('error', sass.logError))
    .pipe(postcss([
      tailwindcss(options.config.tailwindjs),
      require('autoprefixer'),
    ]))
    .pipe(concat({ path: 'style.css'}))
    .pipe(dest(options.paths.src.css));
}

// minify css
function prodStyles(){
  return src(`${options.paths.src.css}/style.css`).pipe(purgecss({
    content: ['./*.html'],
    defaultExtractor: content => {
      const broadMatches = content.match(/[^<>"'`\s]*[^<>"'`\s:]/g) || []
      const innerMatches = content.match(/[^<>"'`\s.()]*[^<>"'`\s.():]/g) || []
      return broadMatches.concat(innerMatches)
    }
  }))
  .pipe(cleanCSS({compatibility: 'ie8'}))
  .pipe(dest(options.paths.dist.css));
}

// finish log
function buildFinish(done){
  console.log("\n\t" + logSymbols.info,`Production is complete. Files are located at ${options.paths.dist.base}\n`);
  done();
}

// generate rtl css
function devRtl(){
  const tailwindcss = require('tailwindcss'); 
  return src(`${options.paths.src.scss}/tailwindrtl.scss`).pipe(sass().on('error', sass.logError))
    .pipe(postcss([
      tailwindcss(options.config.tailwindjs),
      require('autoprefixer'),
    ]))
    .pipe(rtlcss()) // Convert to RTL.
    .pipe(concat({ path: 'style-rtl.css'}))
    .pipe(dest(options.paths.src.css));
}
// Compile RTL CSS
function cssrtl() {
   return src(`${options.paths.src.css}/style-rtl.css`).pipe(purgecss({
    content: ['./*.html'],
    defaultExtractor: content => {
      const broadMatches = content.match(/[^<>"'`\s]*[^<>"'`\s:]/g) || []
      const innerMatches = content.match(/[^<>"'`\s.()]*[^<>"'`\s.():]/g) || []
      return broadMatches.concat(innerMatches)
    }
  }))
  .pipe(cleanCSS({compatibility: 'ie8'}))
  .pipe(dest(options.paths.dist.css));
}

exports.buildrtl = series(devRtl, cssrtl);

exports.default = series( devClean, devStyles, livePreview, watchFiles);

exports.prod = series(
  devClean,
  series(prodStyles),
  buildFinish
);